import { jsx, jsxs } from "react/jsx-runtime";
import { C as Combobox } from "./combobox-BCj7gyvQ.js";
import { I as InputError } from "./input-error-CBKwRgzN.js";
import { L as LoadingButton } from "./loading-button-C9msud_X.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { L as Label } from "./label-BKAgVFnB.js";
import { R as RadioGroup, a as RadioGroupItem } from "./radio-group-B7ePM9gk.js";
import { D as DashboardLayout } from "./layout-Coo-00Zo.js";
import { useForm } from "@inertiajs/react";
import "./button-CoRGprmX.js";
import "react";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "cmdk";
import "lucide-react";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "@radix-ui/react-label";
import "@radix-ui/react-radio-group";
import "./sidebar-4chFkdEZ.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "date-fns";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./app-logo-CP8LgHIG.js";
import "./accordion-DjZKTuzo.js";
import "@radix-ui/react-accordion";
import "./route-DlE7FdTW.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./use-lang-44ndmTOc.js";
const Index = (props) => {
  const { users, courses, prices, translate } = props;
  const { input, button } = translate;
  const { data, setData, post, errors, processing } = useForm({
    user_id: "",
    course_id: "",
    enrollment_type: "free"
  });
  const handleSubmit = (e) => {
    e.preventDefault();
    post(route("enrollments.store"));
  };
  const transformedUsers = users.map((user) => ({
    label: user.name,
    value: user.id
  }));
  const transformedCourses = courses.map((course) => ({
    label: course.title,
    value: course.id
  }));
  return /* @__PURE__ */ jsx(Card, { className: "mx-auto max-w-2xl p-6", children: /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmit, className: "space-y-6", children: [
    /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx(Label, { children: input.select }),
      /* @__PURE__ */ jsx(
        Combobox,
        {
          data: transformedUsers,
          defaultValue: data.user_id,
          placeholder: input.select,
          onSelect: (selected) => setData("user_id", selected.value)
        }
      ),
      /* @__PURE__ */ jsx(InputError, { message: errors.user_id })
    ] }),
    /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx(Label, { children: input.select_course }),
      /* @__PURE__ */ jsx(
        Combobox,
        {
          data: transformedCourses,
          defaultValue: data.course_id,
          placeholder: input.select_course_placeholder,
          onSelect: (selected) => setData("course_id", selected.value)
        }
      ),
      /* @__PURE__ */ jsx(InputError, { message: errors.course_id })
    ] }),
    /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx(Label, { children: input.enrollment_type }),
      /* @__PURE__ */ jsx(
        RadioGroup,
        {
          defaultValue: data.enrollment_type,
          className: "flex items-center space-x-4 pt-2 pb-1",
          onValueChange: (value) => setData("enrollment_type", value),
          children: prices.map((price) => /* @__PURE__ */ jsxs("div", { className: "flex items-center space-x-2", children: [
            /* @__PURE__ */ jsx(RadioGroupItem, { className: "cursor-pointer", id: price, value: price }),
            /* @__PURE__ */ jsx(Label, { htmlFor: price, className: "capitalize", children: price })
          ] }, price))
        }
      ),
      /* @__PURE__ */ jsx(InputError, { message: errors.enrollment_type })
    ] }),
    /* @__PURE__ */ jsx("div", { className: "col-span-2 mt-6 text-right", children: /* @__PURE__ */ jsx(LoadingButton, { loading: processing, children: button.submit }) })
  ] }) });
};
Index.layout = (page) => /* @__PURE__ */ jsx(DashboardLayout, { children: page });
export {
  Index as default
};
